
// FRAGPLAY.CPP
// Source code for producing/playing sound on-the-fly
//
// Version 1.0
// Started by Pieter Geelen, August 1997
// Copyright (c) 1997 by Palmtop BV - The Netherlands

#include "fragplay.h"

TFragmentPlayer::TFragmentPlayer()
{
}

TFragmentPlayer::~TFragmentPlayer()
{
	Close();
};

TInt TFragmentPlayer::ChangeVolume( TSoundVolume aVolume )
{
	// get current sound config and adjust
	iDevSound.Config(config);
	config().iAlawBufferSize	= 0x400;
	config().iVolume			= aVolume;
	return iDevSound.SetConfig(config);
}

TInt TFragmentPlayer::Open( TSoundVolume aVolume )
{ 
	// initialize sound buffer
	iCurrentValue = 0;
	SetSamplesSilent();

	// open sound device
	TInt err = iDevSound.Open();
	if ( err)
		return err;

	// get current sound config and adjust
	iDevSound.Config(config);
	config().iAlawBufferSize	= 0x400;
	config().iVolume			= aVolume;

	// set sound config
	err=iDevSound.SetConfig(config);
	if (err)
		return err;

	// prepare to play alaw
	err=iDevSound.PreparePlayAlawBuffer();
	if (err)
		return err;

	// we are ready to play, thus not playing any bytes right now
	iNrBytesBeingPlayed=0;
	return KErrNone;
}	

// Close the sound device (can't fail)
void TFragmentPlayer::Close()		
{ 
	iDevSound.Close(); 
}

void TFragmentPlayer::AbortPlaying()
{
	iDevSound.FlushPlayBuffer();
	iDevSound.ResetBytesPlayed();
	iNrBytesBeingPlayed=0;
}


TInt TFragmentPlayer::PlayFragment( TInt aSamples )
{

	// finish fragment contents
	if ( iCurrentValue )
	{
		if ( iSoundStart==0 )
			return KErrNone; // whole fragment is silent!
		SetSamples( iSoundStart, KAlawOn, SAMPLES_PER_FRAGMENT-iSoundStart );
	}

	// were we playing?
	if ( iNrBytesBeingPlayed )
	{
#ifdef FINISH_PREVIOUS_FRAGMENT
		// wait for previous sound to finish!
		FinishPlaying();
#else
		// if still playing previous, simply skip THIS fragment
		if ( iDevSound.BytesPlayed() < iNrBytesBeingPlayed )
			return KErrNone;
#endif
		// not playing any more: prepare for next piece of alaw 
		iDevSound.FlushPlayBuffer();	//@@@err?
		iDevSound.ResetBytesPlayed();	//@@@err?
	}

	// buffer the whole fragment...
	TRequestStatus stat;
#ifdef STREAM_AT_ONCE
	iDevSound.PlayAlawData( stat, TPtrC8(iAlawBuf,aSamples) );
	User::WaitForRequest(stat); // @@@ move to NEXT CALL?
	SetSamplesSilent(); // @@@ move BEFORE request?
#else
	for(TInt i=0;i<SAMPLES_PER_FRAGMENT;i+=ALAW_GRANULARITY)
	{
		iDevSound.PlayAlawData( stat , TPtrC8( &iAlawBuf[i],ALAW_GRANULARITY ));
		User::WaitForRequest(stat);
		if (stat!=KErrNone)
			break;
	}
	SetSamplesSilent();
#endif
	TInt err = stat.Int();

	// ...and remember how many bytes we are playing...
	if (err)
		iNrBytesBeingPlayed=0;
	else
		iNrBytesBeingPlayed=SAMPLES_PER_FRAGMENT;

	return err;
}



void TFragmentPlayer::PlayTone(TInt /*aFrequency*/,TInt /*aDurationInMicroSeconds*/)
{
  //@@@ to be written...
}

